﻿namespace Microsoft.Samples.PlanMyNight.Web.Ux
{
    using System;
    using System.Configuration;
    using System.Web.Hosting;
    using Microsoft.Samples.PlanMyNight.Bing;
    using Microsoft.Samples.PlanMyNight.Data;
    using Microsoft.Samples.PlanMyNight.Data.Caching;
    using Microsoft.Samples.PlanMyNight.Entities;

    public class PrewarmApplication : IProcessHostPreloadClient
    {
        public void Preload(string[] parameters)
        {
            var cachingProviderTypeAssembly = ConfigurationManager.AppSettings["Caching.Provider"].Split(',');
            var cachingProvider = (ICachingProvider)Activator.CreateInstance(cachingProviderTypeAssembly[1], cachingProviderTypeAssembly[0], null).Unwrap();

            // Retreive reference data from repository (will fill cache automatically)
            var referenceRepository = new CachedReferenceRepository(cachingProvider, new ReferenceRepository());
            var activityRepository = new CachedActivitiesRepository(cachingProvider, new BingActivitiesRepository(new BingMapsService()));
            referenceRepository.RetrieveStates();
            activityRepository.RetrieveActivityTypes();

            // Do dummy search to cache Bing token
            activityRepository.Search(new NaturalSearchQuery { Query = "Bars in Manhattan, NY", ActivityTypeId = 11199, Page = 1, PageSize = 5 });
        }
    }
}